<?php
function register_new_widgets( $widgets_manager ) {

	require_once( __DIR__ . '/base/video-widget.php' );

	$widgets_manager->register( new \Custom_Video_Widget() );

}
add_action( 'elementor/widgets/register', 'register_new_widgets' );


add_action( 'elementor/controls/controls_registered', function( $controls_manager ) {
	require_once( __DIR__ . '/base/date-widget.php' );

	$controls_manager->register_control( 'persian_date_picker', new \Control_Persian_Date_Picker() );
} );

function register_widget_styles()
{
	wp_register_style('pDate-style',plugins_url('elementor-pro') . '/megatheme/includes/assets/css/persian-datepicker.min.css');

	wp_register_script('pDate',plugins_url('elementor-pro') . '/megatheme/includes/assets/js/persian-date.min.js',array('jquery') );
	wp_register_script('pDatepicker',plugins_url('elementor-pro') . '/megatheme/includes/assets/js/persian-datepicker.min.js' ,array('pDate'));
	wp_register_script('pDatepickerLoader',plugins_url('elementor-pro') . '/megatheme/includes/assets/js/persian-datepicker-loader.js',array('pDatepicker') );
}

add_action('wp_enqueue_scripts', 'register_widget_styles',1);


/**
 * Register additional document controls.
 *
 * @param \Elementor\Core\DocumentTypes\PageBase $document The PageBase document instance.
 */
function register_document_controls( $document ) {

	if ( ! $document instanceof \Elementor\Core\DocumentTypes\PageBase || ! $document::get_property( 'has_elements' ) ) {
		return;
	}

	$document->start_controls_section(
		'date_section',
		[
			'label' =>  'تاریخ شمسی',
			'tab' => \Elementor\Controls_Manager::TAB_SETTINGS,
		]
	);

	$document->add_control(
		'shamsi_date_off',
		[
			'label' => 'خاموش کردن تقویم فارسی',
			'type' => \Elementor\Controls_Manager::SWITCHER,
		]
	);

	$document->end_controls_section();
}
//add_action( 'elementor/documents/register_controls', 'register_document_controls' );


// Add a section to the Elementor settings page
function my_custom_elementor_settings_section() {
	add_settings_section('my_custom_elementor_section', 'My Custom Elementor Settings', 'my_custom_elementor_section_callback', 'elementor');
}

// Section callback function
function my_custom_elementor_section_callback() {
	echo '<p>Customize your Elementor settings here.</p>';
}

// Add a checkbox field to the section
function my_custom_elementor_checkbox_field() {
	add_settings_field('my_custom_elementor_checkbox', 'غیر فعال سازی تاریخ شمسی', 'my_custom_elementor_checkbox_callback', 'elementor', 'elementor_general_section');
	add_settings_field('mc_enable_ai', 'فعال سازی هوش مصنوعی', 'mc_enable_ai_callback', 'elementor', 'elementor_general_section');
	register_setting('elementor', 'my_custom_elementor_checkbox');
	register_setting('elementor', 'mc_enable_ai');
}

// Checkbox callback function
function my_custom_elementor_checkbox_callback() {
	$value = get_option('my_custom_elementor_checkbox');
	echo '<input type="checkbox" name="my_custom_elementor_checkbox" value="1" ' . checked(1, $value, false) . ' />';
}
// Checkbox callback function
function mc_enable_ai_callback() {
	$value = get_option('mc_enable_ai');
	echo '<input type="checkbox" name="mc_enable_ai" value="1" ' . checked(1, $value, false) . ' /><span>با فعال شدن این گزینه ممکنه به خاطر مشکلات زیرساختی اینترنت، سرعت افزونه کم یا سایت شما با کندی مواجه شود.</span>';
}

// Hook into the Elementor settings page
add_action('admin_init', 'my_custom_elementor_checkbox_field');
add_action('admin_init', 'my_custom_elementor_settings_section');

add_action('init',function (){
    if (!get_option('mc_enable_ai')) {
        define('WP_ACCESSIBLE_HOSTS', '*.akismet.com,*.shaparak.ir:8080,*.shaparak.ir,*.zarinpal.com,*.zibal.ir,*.idpay.ir,pay.ir,*.pay.ir,nextpay.org,*.enamad.ir,*.mydigipay.com,ippanel.com,*.payamak-panel.com,*.sms.ir,wordpress.org');
    }
});


